# Copyright (c) 2010-2011 Chortos-2 <chortos@inbox.lv>

__all__ = ('TestCaseNotPassed', 'TestCaseSkipped', 'TimeLimitExceeded',
           'CPUTimeLimitExceeded', 'WallTimeLimitExceeded',
           'MemoryLimitExceeded', 'CanceledByUser', 'WrongAnswer',
           'NonZeroExitCode', 'ExceptionWrapper', 'CannotStartTestee',
           'CannotStartValidator', 'CannotReadOutputFile',
           'CannotReadInputFile', 'CannotReadAnswerFile')

class TestCaseNotPassed(Exception): __slots__ = ()
class TestCaseSkipped(TestCaseNotPassed): __slots__ = ()
class TimeLimitExceeded(TestCaseNotPassed): __slots__ = ()
class CPUTimeLimitExceeded(TimeLimitExceeded): __slots__ = ()
class WallTimeLimitExceeded(TimeLimitExceeded): __slots__ = ()
class MemoryLimitExceeded(TestCaseNotPassed): __slots__ = ()
class CanceledByUser(TestCaseNotPassed): __slots__ = ()

class WrongAnswer(TestCaseNotPassed):
	__slots__ = 'comment'
	def __init__(self, comment=''):
		self.comment = comment

class NonZeroExitCode(TestCaseNotPassed):
	__slots__ = 'exitcode'
	def __init__(self, exitcode):
		self.exitcode = exitcode

class ExceptionWrapper(TestCaseNotPassed):
	__slots__ = 'upstream'
	def __init__(self, upstream):
		self.upstream = upstream

class CannotStartTestee(ExceptionWrapper): __slots__ = ()
class CannotStartValidator(ExceptionWrapper): __slots__ = ()
class CannotReadOutputFile(ExceptionWrapper): __slots__ = ()
class CannotReadInputFile(ExceptionWrapper): __slots__ = ()
class CannotReadAnswerFile(ExceptionWrapper): __slots__ = ()
